/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.event.common.ModsLoadedCallback;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.UpdateModifiersPacket;
import slimeknights.tconstruct.library.utils.GenericTagUtil;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class ModifierManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierManager.class);
    public static final String FOLDER = "tinkering/modifiers";
    public static final String TAG_FOLDER = "tinkering/tags/modifiers";
    public static final class_2960 ENCHANTMENT_MAP = TConstruct.getResource("tinkering/enchantments_to_modifiers.json");
    public static final class_5321<? extends class_2378<Modifier>> REGISTRY_KEY = class_5321.method_29180((class_2960)TConstruct.getResource("modifiers"));
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ModifierId EMPTY = new ModifierId("tconstruct", "empty");
    public static final ModifierManager INSTANCE = new ModifierManager();
    private final Modifier defaultValue;
    private boolean modifiersRegistered = false;
    @VisibleForTesting
    final Map<ModifierId, Modifier> staticModifiers = new HashMap<ModifierId, Modifier>();
    private final Map<ModifierId, Class<?>> expectedDynamicModifiers = new HashMap();
    public static final GenericLoaderRegistry<Modifier> MODIFIER_LOADERS = new GenericLoaderRegistry();
    private Map<ModifierId, Modifier> dynamicModifiers = Collections.emptyMap();
    private Map<class_2960, Collection<Modifier>> tags = Collections.emptyMap();
    private Map<ModifierId, Set<class_6862<Modifier>>> reverseTags = Collections.emptyMap();
    private Map<class_6862<class_1887>, Modifier> enchantmentTagMap = Collections.emptyMap();
    private Map<class_1887, Modifier> enchantmentMap = Collections.emptyMap();
    boolean dynamicModifiersLoaded = false;

    private ModifierManager() {
        super(GSON, FOLDER);
        this.defaultValue = new EmptyModifier();
        this.defaultValue.setId(EMPTY);
        this.staticModifiers.put(EMPTY, this.defaultValue);
    }

    @Deprecated
    public void init() {
        this.fireRegistryEvent();
        this.addDataPackListeners();
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> JsonUtils.syncPackets(player, joined, new UpdateModifiersPacket(this.dynamicModifiers, this.tags, this.enchantmentMap, this.enchantmentTagMap)));
    }

    private void fireRegistryEvent() {
        ModsLoadedCallback.EVENT.register(envType -> new ModifierRegistrationEvent().sendEvent());
        this.modifiersRegistered = true;
    }

    private void addDataPackListeners() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    protected void apply(Map<class_2960, JsonElement> splashList, class_3300 pResourceManager, class_3695 pProfiler) {
        long time = System.nanoTime();
        HashMap redirects = new HashMap();
        this.dynamicModifiers = splashList.entrySet().stream().map(entry -> this.loadModifier((class_2960)entry.getKey(), (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject(), redirects)).filter(Objects::nonNull).collect(Collectors.toMap(Modifier::getId, mod -> mod));
        HashMap<ModifierId, Modifier> resolvedRedirects = new HashMap<ModifierId, Modifier>();
        for (Map.Entry entry2 : redirects.entrySet()) {
            ModifierId modifierId = (ModifierId)((Object)entry2.getKey());
            ModifierId to = (ModifierId)((Object)entry2.getValue());
            if (!this.contains(to)) {
                log.error("Invalid modifier redirect {} as modifier {} does not exist", (Object)modifierId, (Object)to);
                continue;
            }
            resolvedRedirects.put(modifierId, this.get(to));
        }
        int modifierSize = this.dynamicModifiers.size();
        this.dynamicModifiers.putAll(resolvedRedirects);
        for (Map.Entry<ModifierId, Class<?>> entry3 : this.expectedDynamicModifiers.entrySet()) {
            Modifier modifier = this.dynamicModifiers.get((Object)entry3.getKey());
            if (modifier == null) {
                log.error("Missing expected modifier '" + (Object)((Object)entry3.getKey()) + "'");
                continue;
            }
            if (entry3.getValue().isInstance(modifier)) continue;
            log.error("Modifier '" + (Object)((Object)entry3.getKey()) + "' was loaded with the wrong class type. Expected " + entry3.getValue().getName() + ", got " + modifier.getClass().getName());
        }
        this.dynamicModifiersLoaded = true;
        long l = System.nanoTime();
        log.info("Loaded {} dynamic modifiers and {} modifier redirects in {} ms", (Object)modifierSize, (Object)redirects.size(), (Object)Float.valueOf((float)(l - time) / 1000000.0f));
        time = l;
        class_3503 tagLoader = new class_3503(id -> {
            Modifier modifier = ModifierManager.getValue(new ModifierId((class_2960)id));
            if (modifier == this.defaultValue) {
                return Optional.empty();
            }
            return Optional.of(modifier);
        }, TAG_FOLDER);
        this.tags = tagLoader.method_33176(pResourceManager);
        this.reverseTags = GenericTagUtil.reverseTags(REGISTRY_KEY, Modifier::getId, this.tags);
        l = System.nanoTime();
        log.info("Loaded {} modifier tags for {} modifiers in {} ms", (Object)this.tags.size(), (Object)this.reverseTags.size(), (Object)Float.valueOf((float)(l - time) / 1000000.0f));
        this.enchantmentMap = new HashMap<class_1887, Modifier>();
        this.enchantmentTagMap = new LinkedHashMap<class_6862<class_1887>, Modifier>();
        for (class_3298 resource : pResourceManager.method_14489(ENCHANTMENT_MAP)) {
            JsonObject enchantmentJson = JsonHelper.getJson(resource);
            if (enchantmentJson == null) continue;
            for (Map.Entry entry3 : enchantmentJson.entrySet()) {
                try {
                    String key = (String)entry3.getKey();
                    ModifierId modifierId = new ModifierId(JsonHelper.convertToResourceLocation((JsonElement)entry3.getValue(), "modifier"));
                    Modifier modifier = this.get(modifierId);
                    if (modifier == this.defaultValue) {
                        throw new JsonSyntaxException("Unknown modifier " + modifierId + " for enchantment " + key);
                    }
                    if (key.startsWith("#")) {
                        class_2960 tagId = class_2960.method_12829((String)key.substring(1));
                        if (tagId == null) {
                            throw new JsonSyntaxException("Invalid enchantment tag ID " + key.substring(1));
                        }
                        this.enchantmentTagMap.put((class_6862<class_1887>)class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)tagId), modifier);
                        continue;
                    }
                    class_2960 enchantId = class_2960.method_12829((String)key);
                    if (enchantId == null || !class_7923.field_41176.method_10250(enchantId)) {
                        throw new JsonSyntaxException("Invalid enchantment ID " + key);
                    }
                    this.enchantmentMap.put((class_1887)class_7923.field_41176.method_10223(enchantId), modifier);
                }
                catch (JsonSyntaxException e) {
                    log.info("Invalid enchantment to modifier mapping", (Throwable)e);
                }
            }
        }
        log.info("Loaded {} enchantment to modifier mappings in {} ms", (Object)(this.enchantmentMap.size() + this.enchantmentTagMap.size()), (Object)Float.valueOf((float)(System.nanoTime() - l) / 1000000.0f));
        new ModifiersLoadedEvent().sendEvent();
    }

    @Nullable
    private Modifier loadModifier(class_2960 key, JsonElement element, Map<ModifierId, ModifierId> redirects) {
        try {
            JsonObject json = class_3518.method_15295((JsonElement)element, (String)"modifier");
            if (json.has("redirects")) {
                for (JsonRedirect redirect : JsonHelper.parseList(json, "redirects", JsonRedirect::fromJson)) {
                    Predicate<JsonObject> redirectCondition = redirect.getConditionPredicate();
                    if (redirectCondition != null && !redirectCondition.test(json)) continue;
                    ModifierId redirectTarget = new ModifierId(redirect.getId());
                    log.debug("Redirecting modifier {} to {}", (Object)key, (Object)redirectTarget);
                    redirects.put(new ModifierId(key), redirectTarget);
                    return null;
                }
            }
            if (json.has("fabric:load_conditions") && !CraftingHelper.getConditionPredicate((JsonObject)class_3518.method_15296((JsonObject)json, (String)"fabric:load_conditions")).test(json)) {
                return null;
            }
            Modifier modifier = MODIFIER_LOADERS.deserialize((JsonElement)json);
            modifier.setId(new ModifierId(key));
            return modifier;
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load modifier {}", (Object)key, (Object)e);
            return null;
        }
    }

    void updateModifiersFromServer(Map<ModifierId, Modifier> modifiers, Map<class_2960, Collection<Modifier>> tags, Map<class_1887, Modifier> enchantmentMap, Map<class_6862<class_1887>, Modifier> enchantmentTagMappings) {
        this.dynamicModifiers = modifiers;
        this.dynamicModifiersLoaded = true;
        this.tags = tags;
        this.reverseTags = GenericTagUtil.reverseTags(REGISTRY_KEY, Modifier::getId, tags);
        this.enchantmentMap = enchantmentMap;
        this.enchantmentTagMap = enchantmentTagMappings;
        new ModifiersLoadedEvent().sendEvent();
    }

    public Modifier getStatic(ModifierId id) {
        return this.staticModifiers.getOrDefault((Object)id, this.defaultValue);
    }

    public boolean containsStatic(ModifierId id) {
        return this.staticModifiers.containsKey((Object)id) || this.expectedDynamicModifiers.containsKey((Object)id);
    }

    public boolean contains(ModifierId id) {
        return this.staticModifiers.containsKey((Object)id) || this.dynamicModifiers.containsKey((Object)id);
    }

    public Modifier get(ModifierId id) {
        Modifier modifier = this.staticModifiers.get((Object)id);
        if (modifier != null) {
            return modifier;
        }
        return this.dynamicModifiers.getOrDefault((Object)id, this.defaultValue);
    }

    @Nullable
    public Modifier get(class_1887 enchantment) {
        if (this.enchantmentMap.containsKey(enchantment)) {
            return this.enchantmentMap.get(enchantment);
        }
        for (Map.Entry<class_6862<class_1887>, Modifier> mapping : this.enchantmentTagMap.entrySet()) {
            if (!RegistryHelper.contains(class_7923.field_41176, mapping.getKey(), enchantment)) continue;
            return mapping.getValue();
        }
        return null;
    }

    public Stream<class_1887> getEquivalentEnchantments(Predicate<ModifierId> modifiers) {
        Predicate<Map.Entry> predicate = entry -> modifiers.test(((Modifier)entry.getValue()).getId());
        return Stream.concat(this.enchantmentMap.entrySet().stream().filter(predicate).map(Map.Entry::getKey), this.enchantmentTagMap.entrySet().stream().filter(predicate).flatMap(entry -> RegistryHelper.getTagValueStream(class_7923.field_41176, (class_6862)entry.getKey()))).distinct().sorted(Comparator.comparing(enchantment -> Objects.requireNonNull(class_7923.field_41176.method_10221(enchantment))));
    }

    public Stream<class_2960> getAllLocations() {
        return Stream.concat(this.staticModifiers.entrySet().stream(), this.dynamicModifiers.entrySet().stream()).filter(entry -> ((ModifierId)((Object)((Object)entry.getKey()))).equals((Object)((Modifier)entry.getValue()).getId())).map(Map.Entry::getKey);
    }

    public Stream<Modifier> getAllValues() {
        return Stream.concat(this.staticModifiers.values().stream(), this.dynamicModifiers.values().stream()).distinct();
    }

    public static Modifier getValue(ModifierId name) {
        return INSTANCE.get(name);
    }

    public static Modifier convertToModifier(JsonElement element, String key) {
        ModifierId name = new ModifierId(JsonHelper.convertToResourceLocation(element, key));
        if (INSTANCE.contains(name)) {
            return INSTANCE.get(name);
        }
        throw new JsonSyntaxException("Unknown modifier " + name);
    }

    public static Modifier deserializeModifier(JsonObject parent, String key) {
        return ModifierManager.convertToModifier(JsonHelper.getElement(parent, key), key);
    }

    public static Modifier fromNetwork(class_2540 buffer) {
        return INSTANCE.get(new ModifierId(buffer.method_10800(Short.MAX_VALUE)));
    }

    public static void toNetwork(Modifier modifier, class_2540 buffer) {
        buffer.method_10814(modifier.getId().toString());
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("modifier_manager");
    }

    public static class_6862<Modifier> getTag(class_2960 id) {
        return class_6862.method_40092(REGISTRY_KEY, (class_2960)id);
    }

    public static boolean isInTag(ModifierId modifier, class_6862<Modifier> tag) {
        return ModifierManager.INSTANCE.reverseTags.getOrDefault((Object)modifier, Collections.emptySet()).contains(tag);
    }

    public static List<Modifier> getTagValues(class_6862<Modifier> tag) {
        return ((Collection)ModifierManager.INSTANCE.tags.getOrDefault(tag.comp_327(), Collections.emptyList())).stream().toList();
    }

    public Modifier getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isModifiersRegistered() {
        return this.modifiersRegistered;
    }

    public boolean isDynamicModifiersLoaded() {
        return this.dynamicModifiersLoaded;
    }

    private static class EmptyModifier
    extends Modifier {
        private EmptyModifier() {
        }

        @Override
        public boolean shouldDisplay(boolean advanced) {
            return false;
        }
    }

    public static class ModifiersLoadedEvent
    extends BaseEvent {
        public static Event<ModifiersLoadedCallback> EVENT = EventFactory.createArrayBacked(ModifiersLoadedCallback.class, callbacks -> event -> {
            for (ModifiersLoadedCallback e : callbacks) {
                e.onLoaded(event);
            }
        });

        public void sendEvent() {
            ((ModifiersLoadedCallback)EVENT.invoker()).onLoaded(this);
        }
    }

    public class ModifierRegistrationEvent
    extends BaseEvent {
        public static Event<ModifierRegistrationCallback> EVENT = EventFactory.createArrayBacked(ModifierRegistrationCallback.class, callbacks -> event -> {
            for (ModifierRegistrationCallback e : callbacks) {
                e.onRegistration(event);
            }
        });

        public void registerStatic(ModifierId name, Modifier modifier) {
            if (ModifierManager.this.expectedDynamicModifiers.containsKey((Object)name)) {
                throw new IllegalArgumentException(name + " is already expected as a dynamic modifier");
            }
            modifier.setId(name);
            Modifier existing = ModifierManager.this.staticModifiers.putIfAbsent(name, modifier);
            if (existing != null) {
                throw new IllegalArgumentException("Attempting to register a duplicate static modifier, this is not supported. Original value " + existing);
            }
        }

        public void registerExpected(ModifierId name, Class<?> classFilter) {
            if (ModifierManager.this.staticModifiers.containsKey((Object)name)) {
                throw new IllegalArgumentException(name + " is already registered as a static modifier");
            }
            Class<?> existing = ModifierManager.this.expectedDynamicModifiers.putIfAbsent(name, classFilter);
            if (existing != null) {
                throw new IllegalArgumentException("Attempting to register a duplicate expected modifier, this is not supported. Original value " + existing);
            }
        }

        public void sendEvent() {
            ((ModifierRegistrationCallback)EVENT.invoker()).onRegistration(this);
        }

        protected ModifierRegistrationEvent() {
        }
    }

    public static interface ModifiersLoadedCallback {
        public void onLoaded(ModifiersLoadedEvent var1);
    }

    public static interface ModifierRegistrationCallback {
        public void onRegistration(ModifierRegistrationEvent var1);
    }
}

